/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.shape;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.BoxPredicateF;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.RayTraceResult;
import qouteall.q_misc_util.my_util.TriangleConsumer;

public interface PortalShape {
    public boolean isPlanar();

    public class_238 getBoundingBox(UnilateralPortalState var1, boolean var2, double var3);

    public double roughDistanceToPortalShape(UnilateralPortalState var1, class_243 var2);

    @Nullable
    public RayTraceResult raytracePortalShapeByLocalPos(UnilateralPortalState var1, class_243 var2, class_243 var3, double var4);

    @Nullable
    default public RayTraceResult raytracePortalShape(UnilateralPortalState portalState, class_243 from, class_243 to, double leniency) {
        class_243 localTo;
        class_243 localFrom = portalState.transformGlobalToLocal(from);
        RayTraceResult hit = this.raytracePortalShapeByLocalPos(portalState, localFrom, localTo = portalState.transformGlobalToLocal(to), leniency);
        if (hit != null) {
            return new RayTraceResult(hit.t(), portalState.transformLocalToGlobal(hit.hitPos()), portalState.transformVecLocalToGlobal(hit.surfaceNormal()));
        }
        return null;
    }

    @Nullable
    public Plane getOuterClipping(UnilateralPortalState var1);

    @Nullable
    public Plane getInnerClipping(UnilateralPortalState var1, UnilateralPortalState var2, Portal var3);

    @Nullable
    default public List<Plane> getNearbyPortalPlanes(UnilateralPortalState portalState, class_238 box) {
        Plane outerClipping = this.getOuterClipping(portalState);
        if (outerClipping != null) {
            return List.of(outerClipping);
        }
        return null;
    }

    public PortalShape getFlipped();

    public PortalShape getReverse();

    public boolean roughTestVisibility(UnilateralPortalState var1, class_243 var2, boolean var3);

    @Environment(value=EnvType.CLIENT)
    public void renderViewAreaMesh(class_243 var1, UnilateralPortalState var2, TriangleConsumer var3, boolean var4);

    public boolean canCollideWith(Portal var1, UnilateralPortalState var2, class_243 var3, class_238 var4);

    default public boolean isBoxInPortalProjection(UnilateralPortalState portalState, class_238 box) {
        double minZ;
        double minY;
        double minX;
        class_243[] vertexes = Helper.eightVerticesOf(box);
        class_243 originPos = portalState.position();
        class_243[] transformed = new class_243[vertexes.length];
        for (int i = 0; i < transformed.length; ++i) {
            transformed[i] = portalState.transformGlobalToLocal(vertexes[i]);
        }
        double maxX = minX = transformed[0].method_10216();
        double maxY = minY = transformed[0].method_10214();
        double maxZ = minZ = transformed[0].method_10215();
        for (int i = 1; i < 8; ++i) {
            class_243 v = transformed[i];
            minX = Math.min(minX, v.method_10216());
            maxX = Math.max(maxX, v.method_10216());
            minY = Math.min(minY, v.method_10214());
            maxY = Math.max(maxY, v.method_10214());
            minZ = Math.min(minZ, v.method_10215());
            maxZ = Math.max(maxZ, v.method_10215());
        }
        return this.isLocalBoxInPortalProjection(portalState, minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean isLocalBoxInPortalProjection(UnilateralPortalState var1, double var2, double var4, double var6, double var8, double var10, double var12);

    @Nullable
    default public class_265 getThisSideCollisionExclusion(UnilateralPortalState portalState) {
        return null;
    }

    public class_243 getMovementForPushingEntityOutOfPortal(Portal var1, UnilateralPortalState var2, class_1297 var3, class_243 var4);

    public PortalShape cloneIfNecessary();

    @Environment(value=EnvType.CLIENT)
    default public boolean canDoOuterFrustumCulling() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    default public BoxPredicateF getInnerFrustumCullingFunc(Portal portal, class_243 cameraPos) {
        return null;
    }

    @Nullable
    default public class_238 transformEntityActiveCollisionBox(Portal portal, class_238 box, class_1297 entity) {
        return box;
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    default public BoxPredicateF getOuterFrustumCullingFunc(Portal portal, class_243 cameraPos) {
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    default public class_4076 getModifiedVisibleSectionIterationOrigin(Portal portal, class_243 cameraPos) {
        return null;
    }

    public boolean shouldRenderInside(Portal var1, class_238 var2);
}

